<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToCustomersNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql')->table('customers_notifications', function($table) {
            $table->dropColumn('customers_notifications_type');
        });  
        Schema::connection('mysql')->table('customers_notifications', function($table) {
            
            $table->enum('customers_notifications_pattern',['push','in_app'])->default('push')->after('customers_notifications_image'); ;
            $table->enum('customers_notifications_type',['all','some','country','gender'])->default('all')->after('customers_notifications_image'); ;
            $table->unsignedBigInteger('countries_id')->nullable()->after('customers_notifications_type');
            $table->enum('customers_gender',['male','female'])->nullable()->after('customers_notifications_type');
            $table->renameColumn('customers_notifications_title','customers_notifications_title_en')  ;
            $table->renameColumn('customers_notifications_text','customers_notifications_text_en') ;
            $table->text('customers_notifications_text_ar')->nullable()->after('admins_id') ;
            $table->string('customers_notifications_title_ar',255)->nullable()->after('admins_id') ;
            
            $table->foreign('countries_id')->references('countries_id')->on('countries')->cascadeOnUpdate()->nullOnDelete();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->table('customers_notifications', function($table) {
           //
        });
    }
}
